clc
clear all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%Caricamento Dati Prova
 numero_prov="P1";      %cambia il valore in base al campione testato P1 o P2
load pattino1_6bar.txt   %cambia in base al test scelto
Test=pattino1_6bar;      %cambia in base al test scelto

%file pressione manometro, tens monte, tens valle, Q, D [m],L [m], 
%pressione atm [hpa], m [kg]
%pa=Test(1,7)*1e2;
pa=101325;
% P1=pa+Test(:,2)*1e5;
% P2=pa+Test(:,3)*1e5;
P1=pa+sp4(Test(:,2))*1e5;    %monte
P2=pa+sp3(Test(:,3))*1e5;    %valle
%Pprova=P2=pa+sp3(Test(6,3))*1e5

Q=Test(:,4);


%Dimensioni Provino
L= Test(1,6);
D=Test(1,5);
A=(pi*D^2)/4;
V=A*L;
%Materiale Provino (Grafite:barra)
rho_g=2265;                     % Densità grafite    kg/m3
m=Test(1,8);                    % Massa provino      kg        87,07 g
%Condizioni di lavoro
mu=1.77e-5;                     % Viscosità dinamica dell'aria in condizioni normali  N*s/m^2
Rg=287.1;                       % Costante dei gas    J/(kg*k)
T=293;                          % Temperatura  ambiente   K
rho_a=pa/(Rg*T);                % Densità aria ambiente   Kg/m^3
ck=rho_a/60000;                 % Fattore di cnversione portata massica-volumica
G=Q*ck;                         % Portata massica    kg/s
rho_m=(P1+P2)/(2*Rg*T);         % Densità media
% rho_m=mean(rho_m(1:20));

v=G./(rho_m*A);                 % Velocità   m/s

% Calcolo parametri
%Darcy
Porosity=1-m/(rho_g*V);                             % [-]
Permeability=2*mu.*G.*L*Rg*T./(A*(P1.^2-P2.^2));    % m^2
Permeability_m=abs(mean(Permeability(2:12)));        % media dei primi 10 valori con permeabilità più bassa; abs() messo perchè per provino_4bar Permeabilità_m veniva negativo
Permeability_darcy=mean(Permeability(end));          % permeabilità finale ottenuta della legge di Darcy
%(2:12))
% Permeability_m=4e-17;


%Parametri Forchheimer

Re_k=rho_m.*v.*sqrt(Permeability_m)./mu;               % Numero di Reynolds [-]
f_k=(P1-P2).*sqrt(Permeability_m)./(L*rho_m.*v.^2);    % Fattore di attrito [-]
c=f_k-(1./Re_k);                                       % Coefficiente inerziale [-]
c1=c(end);                                             % Coefficiente inerziale finale da inserire nella legge di Frochheimer


% Coefficienti equazione secondo ordine Forchheimer

alfa=32*c.*Rg*T./(pi^2*D^4.*sqrt(Permeability_m));
beta=2*mu*Rg*T./(A*Permeability_m);
epsilon=-(P1.^2-P2.^2)./L;
delta=beta.^2-4*alfa.*epsilon;
 
%Calcolo portata teorica 

G1_th=(-beta+sqrt(delta))./(2*alfa);                             % Portata teorica ottenuta con Forchheimer +
G2_th=(-beta-sqrt(delta))./(2*alfa);                             % Portata teorica ottenuta con Forchheimer -
G3_th=(Permeability_darcy*A.*(P1.^2-P2.^2))/(2*mu*L*Rg*T);       % Portata teorica ottenuta con Darcy per fare il confronto con quella di Forchheimmer
%G1_th=real(G1_th);
% % Risultati
% 
% % % Curva di consumo di aria
% % figure
% % plot(P2./P1,Q,'bo','linewidth',2),grid on, hold on,
% % xlabel(' Pressure Ratio $ \frac{P_2}{P_1} $'),
% % ylabel('  Flow Rate  $Q$ $(\frac{l}{min})$  ANR $ 20^{\circ}$)'),
% % grid on, zoom on
% 
%% 
figure
plot(v,Permeability,'bo','linewidth',2),grid on, hold on,
xlabel('Velocity $ v (m/s) $'),
ylabel('Permeability  $k$ $(m^2)$'),
grid on, zoom on


figure
plot(Re_k(7:end),f_k(7:end),'bo','linewidth',2),grid on, hold on,
xlabel(' $ Re_k $'),
ylabel(' $f_k$'),
grid on, zoom on

figure
plot(P2(7:end)./P1(7:end),c(7:end),'bo','linewidth',2),grid on, hold on,
xlabel(' Pressure Ratio $ \frac{P_2}{P_1} $'),
ylabel(' $c$'),
grid on, zoom on
% % % Curva di consumo di aria
figure
plot(P2./P1,G,'bo','linewidth',2),grid on, hold on,
plot(P2./P1,G1_th,'r','linewidth',2),grid on, hold on,
xlabel(' Pressure Ratio $ \frac{P_2}{P_1} $'),
ylabel('  Flow Rate  $G$ $(\frac{kg}{s})$ '),
title('Forchheimer')
grid on, zoom on
% % % 
figure
plot(P2./P1,G,'bo','linewidth',2),grid on, hold on,
plot(P2./P1,G1_th,'r','linewidth',2),grid on, hold on,
plot(P2./P1,G3_th,'m','linewidth',2),grid on, hold on,
xlabel(' Pressure Ratio $ \frac{P_2}{P_1} $'),
ylabel('  Flow Rate  $G$ $(\frac{kg}{s})$ '),
title('confronto Darcy Forchheimer')
legend('P1 6 bar','Forchheimer','Darcy'),   % cambia in base ai bar del test in questione
grid on, zoom on

% %% SALVATAGGIO PARAMETRIZZATO
Ps=Test(1,1);
stringa_P1=['P1_' num2str(Ps) '_n_' num2str(numero_prov) '=P1;'];
stringa_P2=['P2_' num2str(Ps) '_n_' num2str(numero_prov) '=P2;'];
stringa_Q=['Q_' num2str(Ps) '_n_' num2str(numero_prov) '=Q;'];
stringa_k=['k_' num2str(Ps) '_n_' num2str(numero_prov) '=Permeability;'];
stringa_v=['v_' num2str(Ps) '_n_' num2str(numero_prov) '=v;'];
stringa_G=['G_' num2str(Ps) '_n_' num2str(numero_prov) '=G;'];
stringa_G1_th=['G1_th_' num2str(Ps) '_n_' num2str(numero_prov) '=G1_th;'];
stringa_G3_th=['G3_th_' num2str(Ps) '_n_' num2str(numero_prov) '=G3_th;'];
stringa_Re_k=['Re_k_' num2str(Ps) '_n_' num2str(numero_prov) '=Re_k;'];
stringa_f_k=['f_k_' num2str(Ps) '_n_' num2str(numero_prov) '=f_k;'];


stringa_dynNL=['save pattino_' num2str(numero_prov)   '_' num2str(Ps) 'bar'  ' P1_' num2str(Ps) '_n_' num2str(numero_prov)  ' P2_' num2str(Ps) '_n_' num2str(numero_prov) ' Q_' num2str(Ps) '_n_' num2str(numero_prov) ' v_' num2str(Ps) '_n_' num2str(numero_prov) ' G_' num2str(Ps) '_n_' num2str(numero_prov) ' G3_th_' num2str(Ps) '_n_' num2str(numero_prov)  ' G1_th_' num2str(Ps) '_n_' num2str(numero_prov) ' Re_k_' num2str(Ps) '_n_' num2str(numero_prov) ' f_k_' num2str(Ps) '_n_' num2str(numero_prov) ' k_' num2str(Ps) '_n_' num2str(numero_prov) ];
eval(stringa_P2)
eval(stringa_Q)
eval(stringa_k)
eval(stringa_v)
eval(stringa_G)
eval(stringa_G3_th)
eval(stringa_G1_th)
eval(stringa_Re_k)
eval(stringa_f_k)
eval(stringa_P1)


eval(stringa_dynNL) 

